unit GrafGeomU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    rgAlakzat: TRadioGroup;
    btnLetrehoz: TButton;
    btnMozgat: TButton;
    btnTorol: TButton;
    btnKilep: TButton;
    procedure btnLetrehozClick(Sender: TObject);
    procedure btnTorolClick(Sender: TObject);
    procedure btnMozgatClick(Sender: TObject);
    procedure rgAlakzatClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnKilepClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
uses Geometria;
// A ltrejv alakzatokra a kzs s refencijval hivatkozunk
var
  alakzat:TPozicio=nil;

// A vlasztgombbal kijellt alakzat ltrehozsa
procedure TForm1.btnLetrehozClick(Sender: TObject);
begin
  case rgAlakzat.ItemIndex of
    0 :  alakzat:=TPont.Create(60,100, clYellow);
    1 :  alakzat:=TKor.Create(60,100, clBlue,60);
    2 :  alakzat:=TNegyzet.Create(60,100, clRed,120);
    3 :  alakzat:=TTeglalap.Create(60,100, clGreen,120,180);
  end;
  btnLetrehoz.Enabled:=false;
  btnMozgat.Enabled:=true;
  btnTorol.Enabled:=true;
end;

// Ha az alakzat ltezik, akkor trljk azt
procedure TForm1.btnTorolClick(Sender: TObject);
begin
  if Assigned(Alakzat) then
    begin
     Alakzat.Rajzol(form1.color);
     Alakzat.Free;
     Alakzat:=nil;
    end;
  btnLetrehoz.Enabled:=True;
  btnMozgat.Enabled:=False;
  btnTorol.Enabled:=False;
end;

// Az alakzat mozgatsa vzszintesen
procedure TForm1.btnMozgatClick(Sender: TObject);
var
  x : integer;
begin
  If Alakzat=nil then exit;
  x:=60;
  while x<panel1.left-60 do
    begin
      Alakzat.Mozgat(x,100);
      Sleep(60);
      inc(x,15);
    end;
end;

// A vlasztgomb-csoporton val kattintskor trldik
// a rgi alakzat s ltrejn az j
procedure TForm1.rgAlakzatClick(Sender: TObject);
begin
  btnTorolClick(Sender);
  btnLetrehozClick(Sender);
  Beep;
end;

// A form ltrehozsakor belltjuk a gombok lthatsgt
procedure TForm1.FormCreate(Sender: TObject);
begin
  btnLetrehoz.Enabled:=True;
  btnMozgat.Enabled:=False;
  btnTorol.Enabled:=False;
end;

// Kilps az alkalmazsbl
procedure TForm1.btnKilepClick(Sender: TObject);
begin
  btnTorolClick(Sender);
  form1.close;
end;

// A form tmretezsekor is megjelenti az alakzatot
procedure TForm1.FormResize(Sender: TObject);
begin
  form1.Repaint;
  if Assigned(alakzat) then Alakzat.Frissit;
end;

end.
